#ifndef __SVstProcessInformation__
#define __SVstProcessInformation__

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @struct SVstProcessInformation SVstProcessInformation.hpp
		 * @brief Stores info about the current setup of the vst (blocksize, sr, bpm etc)
		 *
		 * @date 07/05/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: SVstProcessInformation.hpp,v 1.3 2007/02/08 21:08:23 paul Exp $
		 */
		struct SVstProcessInformation
		{
			double m_bpm;				/**< Current bpm */
			double m_sampleRate;		/**< Current sampleRate */
			long m_blockSize;			/**< Current max sampleFrames */
			bool m_enabled;				/**< If we catch an exception this will be set to false.. */
			bool m_blockSizeChanged;	/**< Has the block size changed since the last time */
			bool m_sampleRateChanged;	/**< Has the sample rate changed since the last time */

			/**
			 * Initialise all variables
			 */
			void intialise()
			{
				m_bpm			    = 120.00;
				m_sampleRate	    = 44100.0;
				m_blockSize		    = 1024;
				m_enabled		    = false;
				m_blockSizeChanged  = false;
				m_sampleRateChanged = false;
			}
		};
	}
}
#endif	// End of SVstProcessInformation.hpp